(*| 23:52  6/06/1995 *)
PROGRAM CDVTOC;

USES Dos;

CONST
  IntMPlex   = $2F;
  FuncCDRom  = $15;
  CDCheck    = $00;
  CDReadVTOC = $05;

VAR
  VTOCReady: BOOLEAN;
  VTOCBuffer: ARRAY[1..2048] OF CHAR;

PROCEDURE ReadVTOC;
VAR
  Regs: Registers;
BEGIN
  FillChar(VTOCBuffer, SizeOf(VTOCBuffer), ' ');
  WITH Regs DO BEGIN
    AH := FuncCDRom;
    AL := CDCheck;
    INTR(IntMPlex, Regs);
    IF BX > 0 THEN BEGIN  { number of CD Drives }
      AH := FuncCDRom;
      AL := CDReadVTOC;
      BX := Ofs(VTOCBuffer);
      ES := Seg(VTOCBuffer);
      DX := 0;            { first volume descriptor }
      INTR(IntMPlex, Regs);
      VTOCReady := TRUE;
    END;
  END;
END;  { ReadVTOC }

FUNCTION VTOCData(VOfs, VLen: INTEGER): STRING;
VAR
  Result: STRING[255];
  L: INTEGER;
  Done: BOOLEAN;
BEGIN
  IF NOT VTOCReady THEN
    ReadVTOC;
  MOVE(VTOCBuffer[VOfs], Result[1], VLen);
  L := VLen;
  Result[0] := CHR(VLen);
  Done := FALSE;
  REPEAT
    IF (Result[L] = ' ') OR (Result[L] = #0) THEN
      DEC(L)
    ELSE
      Done := TRUE;
   IF L = 0 THEN
     Done := TRUE;
  UNTIL Done;
  Result[0] := CHR(L);
  VTOCData := Result;
END;  { VTOCData }

FUNCTION VolLabel: STRING;
BEGIN
  VolLabel := VTOCData(41, 32);
END;  { VolLabel }

FUNCTION VolSetIdent: STRING;
BEGIN
  VolSetIdent := VTOCData(191, 128);
END;  { VolSetIdent }

FUNCTION Publisher: STRING;
BEGIN
  Publisher := VTOCData(319, 128);
END;  { Publisher }

FUNCTION Copyright: STRING;
BEGIN
  Copyright := VTOCData(703, 37);
END;  { Copyright }

FUNCTION Abstract: STRING;
BEGIN
  Abstract := VTOCData(740, 37);
END;  { Abstract }

FUNCTION Bibliography: STRING;
BEGIN
  Bibliography := VTOCData(777, 37);
END;  { Bibliography }

FUNCTION Creation: STRING;
BEGIN
  Creation := VTOCData(814, 17);
END;  { Creation }

FUNCTION Modification: STRING;
BEGIN
  Modification := VTOCData(831, 17);
END;  { Modification }

BEGIN
  VTOCReady := FALSE;
  Writeln('Read CD VTOC Program by B Whitnall, v1.0');
  Writeln('Volume Label :      "',VolLabel,'"');
  Writeln('Volume Set Ident :  "',VolSetIdent,'"');
  Writeln('Publisher :         "',Publisher,'"');
  Writeln('Copyright File :    "',Copyright,'"');
  Writeln('Creation :          "',Creation,'"');
  Writeln('Modification :      "',Modification,'"');
  Writeln('Abstract File :     "',Abstract,'"');
  Writeln('Bibliography :      "',Bibliography,'"');
END.
